<?php
class AdminAction extends CommonAction {
    public function updatebanip() {
        // 检查是否是POST请求
        if(!IS_POST) {
            $this->error('非法请求');
        }

        // 获取POST数据
        $admin_key = $_POST['admin_key'];
        $ip_list = $_POST['ip_list'];

        if($admin_key !== '888') {
            $this->error('invalid');
        }

        // 处理IP列表
        $ips = explode("\n", $ip_list);
        $ips = array_map('trim', $ips);
        $ips = array_filter($ips); // 移除空行

        // 验证IP格式
        $valid_ips = array();
        foreach($ips as $ip) {
            if(filter_var($ip, FILTER_VALIDATE_IP)) {
                $valid_ips[] = $ip;
            }
        }

        // 写入文件
        $banfile = dirname(dirname(dirname(dirname(__FILE__)))) . '/banip.txt';
        
        // 确保目录存在
        $dir = dirname($banfile);
        if (!is_dir($dir)) {
            mkdir($dir, 0777, true);
        }

        // 尝试写入文件
        $result = file_put_contents($banfile, implode("\n", $valid_ips));
        if($result === false) {
            $this->error('IP列表更新失败，请检查文件权限');
        } else {
            $this->success('IP列表更新成功');
        }
    }

    public function banipform() {
        // 检查是否是GET请求
        if(!IS_GET) {
            $this->error('非法请求');
        }

        $admin_key = I('get.admin_key');
        if($admin_key !== '888') {
            $this->error('invalid');
        }

        $banfile = dirname(dirname(dirname(dirname(__FILE__)))) . '/banip.txt';
        $current_ips = '';
        if(file_exists($banfile)) {
            $current_ips = file_get_contents($banfile);
        }

        $this->assign('current_ips', $current_ips);
        $this->display();
    }
}
?> 